
	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F1459
	#include p16f1459.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _FOSC_INTOSC & _WDTE_OFF & _PWRTE_ON & _MCLRE_ON & _CP_OFF & _BOREN_OFF & _CLKOUTEN_OFF &_IESO_OFF & _FCMEN_OFF

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _WRT_OFF & _CPUDIV_NOCLKDIV & _USBLSCLK_24MHz & _PLLMULT_3x & _PLLEN_DISABLED & _STVREN_ON & _BORV_HI & _LPBOR_OFF & _LVP_OFF 


; Define variables at memory locations

; Bank 0 RAM

RESP_HI		equ	H'20'	; response high Tailored response curve for high frequency use
RESP_LO		equ	H'21'	; response low
SOFT_S_HI	equ	H'22'	; soft start hi byte reading 
SOFT_S_LO	equ	H'23'	; soft start low byte
BCD			equ	H'24'	; BCD switch value or setting
TEMPX		equ	H'25'	; temporary
TEMP_LO		equ	H'26'	; temporary
TEMP_HI		equ	H'27'	; temporary	
BATT_HI		equ	H'28'	; battery voltage ms bits
BATT_LO		equ	H'29'	; battery voltage ls bits	
A_D_HI		equ	H'2A'	; A/D conversion high byte (low byte at all banks RAM)
UV_SET_LO	equ	H'2B'	; undervoltage setting low byte
UV_SET_HI	equ	H'2C'	; undervoltage setting high byte
UNDER_V		equ	H'2D'	; undervoltage flag	
FB_HI		equ	H'2E'	; feedback reading ms byte
FB_LO		equ	H'2F'	; feedback reading ls byte
SPEED_HI	equ	H'30'	; speed setting ms byte
SPEED_LO	equ	H'31'	; speed setting ls byte
;DO_NOT_USE equ H'32'	; faulty memory location in test PIC
SOFT_FLG	equ	H'33'	; soft start flag
SPEED_S_HI	equ	H'34'	; speed under soft starting high byte
SPEED_S_LO	equ	H'35'	; speed under soft starting low byte
WKG_SPEED_H	equ	H'36'	; working speed value ms byte
WKG_SPEED_L	equ	H'37'	; working speed value ls byte
DIV_CALC_H	equ	H'38'	; division calculation ms byte
DIV_CALC_L	equ	H'39'	; division calculation ls byte
AV_H		equ	H'3A'	; average feedback high byte
AV_L		equ	H'3B'	; average feedback low byte
AVERAGE		equ	H'3C'	; average counter
UV_COUNTER	equ	H'3D'	; undervoltage counter
FB_CHNG_L	equ	H'3E'	; changed FB value needs to be a temporary working value
FB_CHNG_H	equ	H'3F'	; changed FB value needs to be a temporary working value	
FB_START	equ	H'40'	; feedback start flag
FB_COUNTER	equ	H'41'	; feedback counter
OFFSET_H	equ	H'42'	; IC3 amplifier offset high byte, measured when VR1 is off
OFFSET_L	equ	H'43'	; IC3 amplifier offset high byte, measured when VR1 is off	
TEST_H		equ	H'44'	; test readings for offset high byte
TEST_L		equ	H'45'	; test readings for offset low byte

; math routines

TEMPB0		equ	H'5D'
TEMPB1		equ	H'5E'
TEMPB2		equ	H'5F'
TEMP		equ H'60'
REMB3		equ H'61'
REMB2		equ	H'62'
REMB1      	equ H'63'
REMB0		equ	H'64'
AARGB5		equ	H'65'
AARGB4      equ H'66'
AARGB3		equ	H'67'
AARGB2      equ H'68'
AARGB1      equ H'69'
AARGB0      equ H'6A'	; most significant byte of argument A
BARGB3      equ H'6B'
BARGB2      equ H'6C'
BARGB1      equ H'6D'
BARGB0      equ H'6E'	; most significant byte of argument B
LOOPCOUNT   equ H'6F'  	; division counter

; All banks

A_D_LOW		equ	H'70'	; least significant bits for A/D conversion

; define reset and interrupt vector start addresses

	org		0  				; start at address 0000h
	goto	MAIN
	org     4				; not used, interrupt vector 0004h, start interrupt routine here


;***************************************************************************************
MAIN

; CWG
	movlb	D'13'			; bank 13, CWG
	bcf		CWG1CON0,G1EN	; CWG disabled 

; set inputs/outputs
	movlb	D'2'			; latch, bank 2
	clrf	LATC

;USB
	movlb	D'29'
	bcf		UCON,3		; USB off
	bcf		UCON,1
	
; weak pullups off/on
	movlb	D'4'			; bank4	WPUA/B
	movlw	B'00101000'
	movwf	WPUA
	movlw	B'11100000'
	movwf	WPUB

; set I/O
	movlb	D'1'		; bank1	TRISA/B/C

	movlw	B'00111011'	; 
	movwf	TRISA
	movlw	B'11110000'	; 
	movwf	TRISB
	movlw	B'10001111'	; 
	movwf	TRISC

; options
	movlw	B'00000000'	; weak pullups set via WPUA/B
	movwf	OPTION_REG	; 

; analog inputs
	movlb	D'3'		; bank3	ANSELA/B/C
	movlw	B'00001000'	; AN3
	movwf	ANSELA
	movlw	B'10001111' ; AN4-7, AN9
	movwf	ANSELB
	movlw	B'00010000'	; AN10
	movwf	ANSELC

; oscillator
	movlb	D'1'	
	movlw	B'11111000'	; for 24MHz; 8MHz x 3PLL
	movwf	OSCCON	; osc

; timer2 set
	movlb	D'0'		; bank0	
	movlw	D'254'		; PWM  
	movwf	PR2			; PWM period register

	movlw	B'00000100'
	movwf	T2CON

; ensure the USB is off as it affects the RA0 and RA1 inputs for switches
	movlb	D'29'
	bcf		UCON,3			; usb off
	movlb	D'0'			; bank 0

; timer1 set up
	movlw	B'11000001'		; uses internal 31kHz oscillator and /1 prescaler (bits 5,4) 
	movwf	T1CON			; 2.088s overflow and 32us per count

; check switch S1 for operating frequency

	call	BCD_FREQUENCY	

; wait 65.5ms, time for RC5 and RC4 to have gate of Q1 and Q2 low
; preload with FFFF-D2048= F7FF
	movlw	H'F7'
	call	DELAY

; set up A/D
	movlb	D'1'			; bank1	ADCON0/1/2
	movlw	B'00010100'		; channel 5
	movwf	ADCON0
	movlw	B'11110000'		; right justified
	movwf	ADCON1
	bsf		ADCON0,ADON		; A/D on
	movlb	D'0'			; bank 0
	
; initial states
	bsf		SOFT_FLG,0		; set initially for undervoltage check at power up

	clrf	UNDER_V			; undervoltage flag cleared
	call	UNDER_VOLT		; checks for low battery as power up

	clrf	SOFT_FLG		; soft start flag
	clrf	SPEED_S_HI		; speed during soft start high byte
	clrf	SPEED_S_LO		; low byte
	movlw	D'242'
	movwf	UV_COUNTER		; undervoltage counter
	clrf	FB_START		; feedback start flag
	clrf	FB_COUNTER		; feedback counter


; set up discharge of hold capacitor
	movlb	D'12'			; bank12  PWM	
	clrf	PWM1DCH
	clrf	PWM2DCH
	clrf	PWM1DCL
	clrf	PWM2DCL			;
	movlb	D'0'

	call	OFFSET
	goto	LOOP

OFFSET
; initialise test readings
	movlw	D'255'
	movwf	TEST_H
	movwf	TEST_L
	
; Stop PWM, PWM clear
	movlb	D'12'
	movlw	B'00000000'	; clear PWM mode for PWM2
	movwf	PWM2CON		; disable PWM1 operation
	clrf	PWM2DCL
	clrf	PWM2DCH		; 0 duty cycle  
	movlb	D'0'		; bank 0'

; drive PWM2 output to discharge capacitor

	bsf		PORTC,6		; on (stays on until capacitor is discharged)

READ_FB
	
; read Feedback at AN9. 10-bit for IC3 (offset of IC3)
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00100100'	; channel 9
	movwf	ADCON0
	movlw	B'11110000'	; right justified
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	movlb	D'0'		; bank 0
	call	AD_1		; ms result A_D_HI, ls byte in A_D_LOW

; cycle until readings are equal

	movf	A_D_HI,w
	xorwf	TEST_H,w
	btfss	STATUS,Z
	goto	TRANSF_X
	movf	A_D_LOW,w
	xorwf	TEST_L,w
	btfsc	STATUS,Z
	goto	USE
TRANSF_X
	movf	A_D_HI,w
	movwf	TEST_H
	movf	A_D_LOW,w
	movwf	TEST_L
	goto	READ_FB

; both the same so value is suitable
; assume high byte is zero (ie offset is below 1.25V)
USE	
	bcf		PORTC,6	
	movlw	H'F6'		; 74.32ms(about 8.258ms per count from FF)
	call	DELAY

	movf	A_D_LOW,w
	movwf	OFFSET_L
; add 2 
	movlw	D'2'
	addwf	OFFSET_L,f

; re-allow PWM
	movlb	D'12'
	clrf	PWM2DCL
	clrf	PWM1DCL
	clrf	PWM1DCH
	clrf	PWM2DCH			; 0 duty cycle  
	movlw	B'11100000'		; set PWM mode for PWM2
	movwf	PWM2CON			; enable PWM2 operation
	movlb	D'0'			; bank 0'
	return

;....................................................................

LOOP ; program returns to here

; FREQUENCY SETTING

; check if frequency setting is changed
; read BCD switch
; 16 position BCD switch
; RA1,RB6,RB7,RB5 are the ports RB5 is lsb
	movlw	B'00001111'	; initially load 15 (F)
	movwf	TEMPX		; BCD switch setting
	btfsc	PORTA,1		; if set clear bit 3
	bcf		TEMPX,3		; ms bit of 4-bit BCD
	btfsc	PORTB,6		; if set clear bit 2
	bcf		TEMPX,2		; ms bit of 4-bit BCD
	btfsc	PORTB,7		; if set clear bit 1
	bcf		TEMPX,1		; ms bit of 4-bit BCD
	btfsc	PORTB,5		; if set clear bit 0
	bcf		TEMPX,0		; ms bit of 4-bit BCD
; compare with BCD read previously. If not the same, re-adjust PWM frequency
	movf	TEMPX,w	
	xorwf	BCD,w
	btfss	STATUS,Z
	call	BCD_FREQUENCY	; PWM frequency as per BCD switch setting.

;.......................................................................

; Under Voltage check
	call	UNDER_VOLT		; checks for low battery

;..........................................................................

; if low feedback (motor connection open), switch off PWM and flash LED.
; wait for speed >3
	btfss	FB_START,1		; if set then flash LED 
	goto	RUN2
; clear PWM
	movlb	D'12'			; bank12  PWM	
	clrf	PWM1DCH			; PWM outputs low
	clrf	PWM2DCH

; Stop PWM, PWM clear
	movlw	B'00000000'	; clear PWM mode for PWM2
	movwf	PWM2CON		; disable PWM1 operation
	clrf	PWM2DCL
	clrf	PWM2DCH		; 0 duty cycle  
	movlb	D'0'		; bank 0'

; flash LED to indicate Under Voltage
	btfss	PORTC,6
	goto	FLASH_ON0
	bcf		PORTC,6		; off

	movlw	H'DF'		; about 264ms (about 8.258ms per count from FF)
	call	DELAY

FLASH_ON0
	bsf		PORTC,6		; on
	movlw	H'DF'		; 264ms flash (about 8.258ms per count from FF)
	call	DELAY


; Read VR1 speed value AN5. 
; bit 6-2 CHS<4:0>: Analog Channel Select bits

	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00010100'	; channel 5
	movwf	ADCON0

	movlw	B'11110000'	; right justified
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	movlb	D'0'		; bank 0

; speed setting
	call	ACQUIRE_AD	; ms result A_D_HI, ls byte in A_D_LOW

	movf	A_D_HI,w
	movwf	SPEED_HI
	movf	A_D_LOW,w
	movwf	SPEED_LO

	movf	SPEED_HI,w	; high byte of working speed setting
	btfss	STATUS,Z	; if zero, check low byte
	goto	RUN_RESET

	movf	SPEED_LO,w
	sublw	D'3'
	btfss	STATUS,C
	goto	LOOP

RUN_RESET
	bcf		FB_START,1		; feedback start flag for when motor disconnected detected.
; reallow PWM
	movlb	D'12'
	clrf	PWM2DCL
	clrf	PWM1DCL
	clrf	PWM1DCH
	clrf	PWM2DCH			; 0 duty cycle  
	movlw	B'11100000'		; set PWM mode for PWM2
	movwf	PWM2CON			; enable PWM2 operation
	movlb	D'0'			; bank 0'

; SPEED setting
RUN2

; Read VR1 speed value AN5. 
; bit 6-2 CHS<4:0>: Analog Channel Select bits

	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00010100'	; channel 5
	movwf	ADCON0

	movlw	B'11110000'	; right justified
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	movlb	D'0'		; bank 0

READ_VR1
	call	ACQUIRE_AD	; ms result A_D_HI, ls byte in A_D_LOW

	movf	A_D_HI,w
	movwf	SPEED_HI
	movf	A_D_LOW,w
	movwf	SPEED_LO

; if speed is 0 then soft start
	movf	SPEED_HI,w	; high byte of working speed setting
	btfss	STATUS,Z	; if zero, check low byte
	goto	WAI

	movf	SPEED_LO,w
	sublw	D'3'
	btfss	STATUS,C
	goto	WAI

	clrf	FB_START	; clear feedback detect flag when speed pot off
	clrf	FB_COUNTER
	clrf	SOFT_FLG	; cleared when speed is 0
	clrf	SPEED_S_HI	; speed during soft start high byte
	clrf	SPEED_S_LO	; low byte
	clrf	FB_HI
	clrf	FB_LO
	clrf	AV_H
	clrf	AV_L
	clrf	AVERAGE

	movlb	D'12'			; bank12  PWM	
	clrf	PWM1DCH
	clrf	PWM2DCH
	clrf	PWM1DCL
	clrf	PWM2DCL			
	movlb	D'0'

	call	OFFSET			; get offset for IC3
	goto	LOOP
	
WAI
; wait for speed to go above 3 before running soft start
	movf	SPEED_HI,w		; high byte of speed setting
	btfss	STATUS,Z		; if zero, check low byte
	goto	CK_SOFT

	movf	SPEED_LO,w
	sublw	D'3'
	btfsc	STATUS,C
	goto	RUN_S

CK_SOFT
; check soft start if running or ended
	movf	SOFT_FLG,w
	btfss	STATUS,Z
; soft start flag. If set then transfer VR1 reading to PWM
	goto	SOFT_OFF
; run soft start
; read soft start setting, increase PWM up to SPEED at soft start rate (0=fast, 255 slowest)

; increase SPEED_S_LO and SPEED_S_HI
	movlw	D'4'
	addwf	SPEED_S_LO,f
	btfsc	STATUS,C		; if carry add to MS byte
	incf	SPEED_S_HI,f	; won't overflow as stops at 1024 (10-bits)

; compare with SPEED_HI and SPEED_LO
	movf	SPEED_HI,w		; high byte of speed setting
	subwf	SPEED_S_HI,w	; take from soft start setting
	movwf	TEMPX			; store
	movf	SPEED_LO,w		; low byte
	subwf	SPEED_S_LO,w	; setting
	btfss	STATUS,C
	decf	TEMPX,f			; decrease if required
	btfsc	TEMPX,7			; if set then speed setting > soft start speed
	goto	RUN_S
	bsf		SOFT_FLG,0		; end of soft start	
	goto	SOFT_OFF		; set SOFT_FLG,0 when equal or more

; continue to increase until equal

RUN_S
	comf	SOFT_S_HI,w		; soft start high byte used in ls byte of timer 1.
; complementary value required (8.25ms max, 32.25us per value) 
	call	DELAY2			; delay with timer1
	
; transfer to working registers
; use SPEED_S_HI, SPEED_S_LO when flag is clear
	movf	SPEED_S_LO,w
	movwf	WKG_SPEED_L
	movf	SPEED_S_HI,w
	movwf	WKG_SPEED_H
	goto	ALT_FB			; alter with feedback

SOFT_OFF
; transfer to working registers
; use SPEED_HI, SPEED_LO when SOFT_FLG,0 is set
	movf	SPEED_LO,w
	movwf	WKG_SPEED_L
	movf	SPEED_HI,w
	movwf	WKG_SPEED_H

ALT_FB
; alter SPEED with Feedback (FB_HI, FB_LO)

; sliding divisor for non linear FB control improving low speed FB
; transfer FB values to temporary ram
	movf	FB_HI,w
	movwf	FB_CHNG_H
	movf	FB_LO,w
	movwf	FB_CHNG_L

; check response type
	btfsc	PORTA,5		; if clear then take response from feedback
	goto	MTLP

; transfer values to temporary
	movf	RESP_HI,w
	movwf	TEMP_HI
	movf	RESP_LO,w
	movwf	TEMP_LO

; if bit 1 in high byte is set, complement the value
	btfss	TEMP_HI,1	; bit 1 (used as motor disconnected detect on or off flag)
	goto	DIV_X
	comf	TEMP_HI,f
	movlw	B'00000001'
	andwf	TEMP_HI,f
	comf	TEMP_LO,f

DIV_X
; divide response by 4
;	lsrf	TEMP_HI,f
;	rrf		TEMP_LO,f
	lsrf	TEMP_HI,f
	rrf		TEMP_LO,f
; take response from feedback as an offset
	movf	TEMP_HI,w
	subwf	FB_CHNG_H,f
	movf	TEMP_LO,w
	subwf	FB_CHNG_L,f
	btfss	STATUS,C
	decf	FB_CHNG_H,f
	btfss	FB_CHNG_H,7	; is set, clear
	goto	MTLP
	clrf	FB_CHNG_H
	clrf	FB_CHNG_L
	goto	ALTER

MTLP
; multiply WKG_SPEED by FB
	movf	WKG_SPEED_L,w	; ls byte
	movwf	AARGB2
	movf	WKG_SPEED_H,w	;  ms byte
	movwf	AARGB1
	clrf	AARGB0			; ms byte

	movf	FB_CHNG_L,w
	movwf	BARGB2
	movf	FB_CHNG_H,w
	movwf	BARGB1
	clrf	BARGB0
	call	FXM2424U		; multiply
; result in AARGB0,1,2,3,4,5
; shift result for division	
	movf	AARGB2,w		; ms of multiplication
	movwf	AARGB0
	movf	AARGB3,w		; ls byte
	movwf	AARGB1
	movf	AARGB4,w		; ms of multiplication
	movwf	AARGB2
	movf	AARGB5,w		; ls byte
	movwf	AARGB3
; Divide by sliding divisor
	clrf	BARGB0
	clrf	BARGB1
	clrf  	BARGB2

; divisor; 10(max gain) plus WKG_SPEED so gain varies with value
	movf	WKG_SPEED_H,w
	movwf	TEMP_HI
	movf	WKG_SPEED_L,w
	movwf	TEMP_LO
	movlw	D'10'
	addwf	TEMP_LO,w		;
	movwf	BARGB3	
	btfsc	STATUS,C
	incf	BARGB2,f
	movf	BARGB2,w
	addwf	TEMP_HI,W
	movwf	BARGB2
	call	FXD3232U		; divide

; result in AARGB2,	AARGB3,w
; check for 3FF or more	
	movf	AARGB2,w	; if 4 then over
	sublw	D'3'
	btfss	STATUS,C	
	goto	SET_MAX
	movf	AARGB1,w
	btfss	STATUS,Z
	goto	SET_MAX

; add to working speed
	movf	AARGB3,w
	addwf	WKG_SPEED_L,f
	btfsc	STATUS,C
	incf	AARGB2,f
	movf	AARGB2,w
	addwf	WKG_SPEED_H,f

; check for 3FF or more	
	movf	WKG_SPEED_H,w	; if 4 then over
	sublw	D'3'
	btfsc	STATUS,C	
	goto	ALTER
; set at maximum
SET_MAX
	movlw	H'03'
	movwf	WKG_SPEED_H
	movlw	H'FF'
	movwf	WKG_SPEED_L
	goto	FINAL	

ALTER; the speed pot response curve	

; check response type
	btfss	PORTA,5		; if set then add response to working value
	goto	FINAL

; RESPONSE CURVE
 
	movf	RESP_HI,w
	movwf	TEMP_HI
	movf	RESP_LO,w
	movwf	TEMP_LO

; if bit 1 in high byte is set, complement the value
	; if bit 1 in high byte is set, complement the value
	btfss	TEMP_HI,1	; bit 1 (used as motor disconnected detect on or off flag)
	goto	DIV_Y
	comf	TEMP_HI,f
	movlw	B'00000001'
	andwf	TEMP_HI,f
	comf	TEMP_LO,f

DIV_Y

; divide by 2
;	asrf	TEMP_HI,f
;	rrf		TEMP_LO,f	

;  add to working speed value
	movf	TEMP_LO,w	
	addwf	WKG_SPEED_L,f
	btfsc	STATUS,C		; if over, increase ms byte
	incf	WKG_SPEED_H,f
	movf	TEMP_HI,w
	addwf	WKG_SPEED_H,f

; add response value to 3FF for divisor part of calculation
; (1023/(1023+response)) x WKG_SPEED
; so can adjust WKG_SPEED to range up to 1023 maximum. 

	movlw	H'FF'	
	addwf	RESP_LO,w
	movwf	DIV_CALC_L	; division calculation ls byte
	movlw	H'4'		; if carry is set, use additional count of 4
	btfss	STATUS,C	; 
	movlw	H'3'		; carry clear so use 3
	addwf	RESP_HI,w
	movwf	DIV_CALC_H

; multiply WKG_SPEED by 1023
	movf	WKG_SPEED_L,w	; ls byte
	movwf	AARGB2
	movf	WKG_SPEED_H,w	;  ms byte
	movwf	AARGB1
	clrf	AARGB0			; ms byte

; Multiply by decimal 1023
	movlw	H'FF'
	movwf	BARGB2
	movlw	H'3'
	movwf	BARGB1
	clrf	BARGB0
	call	FXM2424U		; multiply

; shift result for division	
	movf	AARGB2,w		; ms of multiplication
	movwf	AARGB0
	movf	AARGB3,w		; ls byte
	movwf	AARGB1
	movf	AARGB4,w		; ms of multiplication
	movwf	AARGB2
	movf	AARGB5,w		; ls byte
	movwf	AARGB3
; Divide by DIV_CALC
	clrf	BARGB0
	clrf	BARGB1
	movf	DIV_CALC_H,w	
	movwf  	BARGB2
	movf	DIV_CALC_L,w
	movwf	BARGB3	
	call	FXD3232U		; divide

; result in AARGB2,	AARGB3,w
	movf	AARGB3,w
	movwf	WKG_SPEED_L		; shaped speed curve low byte
	movf	AARGB2,w
	movwf	WKG_SPEED_H		; shaped speed curve high byte
	
; final value needs to be shifted from right justified to left justified for PWM (6 shifts)
FINAL
	aslf	WKG_SPEED_L,f		; shift 1, carry is 0
	rlf		WKG_SPEED_H,f		; carry from low byte
	aslf	WKG_SPEED_L,f		; 2
	rlf		WKG_SPEED_H,f
	aslf	WKG_SPEED_L,f		; 3
	rlf		WKG_SPEED_H,f
	aslf	WKG_SPEED_L,f		; 4
	rlf		WKG_SPEED_H,f
	aslf	WKG_SPEED_L,f		; 5
	rlf		WKG_SPEED_H,f
	aslf	WKG_SPEED_L,f		; 6
	rlf		WKG_SPEED_H,f

; clear PWM when speed setting is zero
; if 0 
	
	movf	SPEED_HI,w		; high byte of speed setting
	btfss	STATUS,Z		; if zero, check low byte
	goto	W_CYC

	movf	SPEED_LO,w
	btfsc	STATUS,Z
	goto	CLEAR_WKG
	decfsz	SPEED_LO,w		; check if 1
	goto	W_CYC
CLEAR_WKG	
	clrf	WKG_SPEED_H		; speed cleared
	clrf	WKG_SPEED_L
	goto	CL_SFT

W_CYC
; if working speed is 0 then soft start
	movf	WKG_SPEED_H,w	; high byte of working speed setting
	btfss	STATUS,Z		; if zero, check low byte
	goto	SS

	movf	WKG_SPEED_L,w
	btfss	STATUS,Z
	goto	SS
CL_SFT
	clrf	SOFT_FLG		; cleared when speed is 0
	clrf	SPEED_S_HI		; speed during soft start high byte
	clrf	SPEED_S_LO		; low byte
	clrf	FB_HI
	clrf	FB_LO
	clrf	AV_H
	clrf	AV_L
	clrf	AVERAGE

SS; soft start check flag

; bypass cycle wait when in soft start
	btfss	SOFT_FLG,0
	goto	BY_CYCL

; check if PWM and working value the same. If so bypass drive and then wait for timer flag
	movf	WKG_SPEED_L,w
	movlb	D'12'		; bank
	xorwf	PWM1DCL,w
	movlb	D'0'
	btfss	STATUS,Z
 	goto	W1			; not the same
	movf	WKG_SPEED_H,w
	movlb	D'12'		; bank
	xorwf	PWM1DCH,w
	movlb	D'0'
	btfsc	STATUS,Z
	goto	RESP
W1
; wait for cycle
	bcf		PIR1,TMR2IF
DUTY_WAIT
	btfss	PIR1,TMR2IF		; if set then change duty
	goto	DUTY_WAIT 
	bcf		PIR1,TMR2IF
BY_CYCL
	movf	WKG_SPEED_H,w	; ms byte
	movlb	D'12'			; bank12  PWM	
	movwf	PWM1DCH
	movwf	PWM2DCH
	movlb	D'0'
; clear low byte load when in soft start
	btfss	SOFT_FLG,0
	clrf	WKG_SPEED_L
	movf	WKG_SPEED_L,w
	movlb	D'12'			; bank12  PWM	
	movwf	PWM1DCL
	movwf	PWM2DCL
	movlb	D'0'

;.........................................................................................

RESP ; response curve setting. RESP_HI and RESP_LO for 10-bit result
; bit 6-2 CHS<4:0>: Analog Channel Select bits
; read Response at AN4
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00010000'	; channel 4
	movwf	ADCON0
	movlw	B'11110000'	; right justified
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	movlb	D'0'		; bank 0
	call	ACQUIRE_AD	; ms result A_D_HI, ls byte in A_D_LOW
	movf	A_D_HI,w	; A/D ms byte
	movwf	RESP_HI		; to response store
	movf	A_D_LOW,w	
	movwf	RESP_LO

;FEEDBACK
FB
; read Feedback at AN9. 10-bit
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00100100'	; channel 9
	movwf	ADCON0
	movlw	B'11110000'	; right justified
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	movlb	D'0'		; bank 0
	call	ACQUIRE_AD	; ms result A_D_HI, ls byte in A_D_LOW

; check response flag (bit 1 in high byte) determines if motor off detect is on or off.
	btfss	RESP_HI,1	; if set then detect motor off
	goto	DO_AVG		; FB averaging

; if FB is near zero, clear pwm and soft start 
	movf	A_D_HI,w
	btfss	STATUS,Z	; high byte 0 so check low byte	
	goto	DO_AVG
	movf	A_D_LOW,w
	subwf	OFFSET_L,w	; assumes OFFSET_H is zero
	btfss	STATUS,C
	goto	DO_AVG
; FB is low. Check if already detected
	btfsc	FB_START,0	; if set then run counter
	goto	FBCOUNT	

	bsf		FB_START,0
	movlw	D'255'
	movwf	FB_COUNTER
FBCOUNT
	movf	FB_COUNTER,w
	btfsc	STATUS,Z
	goto	STILL_LO
	decfsz	FB_COUNTER,f
	goto	DO_AVG1

STILL_LO
	bsf		FB_START,1		; low feedback detected for full counter period
	clrf	WKG_SPEED_H		; speed cleared
	clrf	WKG_SPEED_L
	clrf	SOFT_FLG	; cleared when speed is 0
	clrf	SPEED_S_HI	; speed during soft start high byte
	clrf	SPEED_S_LO	; low byte
	clrf	FB_HI
	clrf	FB_LO
	clrf	AV_H
	clrf	AV_L
	clrf	AVERAGE

	movlb	D'12'			; bank12  PWM	
	clrf	PWM1DCH
	clrf	PWM2DCH			; duty 0
	clrf	PWM1DCL
	clrf	PWM2DCL
	movlb	D'0'
	goto	DO_AVG1

DO_AVG

	clrf	FB_START	; feedback start flag
	clrf	FB_COUNTER	; feedback counter

DO_AVG1
	incf	AVERAGE,w	; check value
	sublw	D'64'		; if over 64 then transfer to feedback values and start average again
	btfss	STATUS,C
	goto	TRANS_FB

; keep adding
	incf	AVERAGE,f	; next average
	movf	A_D_LOW,w
	addwf	AV_L,f
	btfsc	STATUS,C	; if over then increase ms byte
	incf	A_D_HI,f
	movf	A_D_HI,w
	addwf	AV_H,f
; average out in AV_H and AV_L for 64 readings
	goto	SOFT	

TRANS_FB ; Transfer feedback values 
; divide by 64 then transfer to FB_HI,LO
	asrf	AV_H,f
	rrf		AV_L,f	; 2
	asrf	AV_H,f
	rrf		AV_L,f	; 4
	asrf	AV_H,f
	rrf		AV_L,f	; 8
	asrf	AV_H,f
	rrf		AV_L,f	; 16
	asrf	AV_H,f
	rrf		AV_L,f	; 32
	asrf	AV_H,f
	rrf		AV_L,f	; 64

	movf	AV_H,w		; average ms byte
	movwf	FB_HI		; to feedback store
	movf	AV_L,w	
	movwf	FB_LO	
; clear	
	clrf	AV_H
	clrf	AV_L
	clrf	AVERAGE

;'''''''''''''''''''''''''''''''''''''''''''''''''''''

; soft start 
SOFT
; read soft start rate at AN6
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00011000'	; channel 6
	movwf	ADCON0
	movlw	B'01110000'	; left justified
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	movlb	D'0'		; bank 0
	call	ACQUIRE_AD	; ms result A_D_HI, ls byte in A_D_LOW
	movf	A_D_HI,w	; A/D ms byte
	movwf	SOFT_S_HI	; to soft store
	movf	A_D_LOW,w	
	movwf	SOFT_S_LO
	goto	LOOP			; bypass writing flash as both the same

;.................................................................................
; subroutines

UNDER_VOLT

; UNDER VOLTAGE

; don't run during soft start as it can slow down the rate especially at low PWM frequency settings where clock
; frequency is slower

	movf	SOFT_FLG,w
	btfss	STATUS,Z		; Soft start; if on (flag is zero), then don't run undervoltage check
	goto	RUN_UV			; soft start is off so check undervoltage

; Read VR1 speed value AN5. 
; bit 6-2 CHS<4:0>: Analog Channel Select bits

	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00010100'	; channel 5
	movwf	ADCON0

	movlw	B'11110000'	; right justified
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	movlb	D'0'		; bank 0

;READ_VR1
	call	ACQUIRE_AD	; ms result A_D_HI, ls byte in A_D_LOW

	movf	A_D_HI,w
	movwf	SPEED_HI
	movf	A_D_LOW,w
	movwf	SPEED_LO
							; except when speed pot is zero (ie no PWM output)
	movf	SPEED_HI,w		; high byte of speed setting
	btfss	STATUS,Z		; if zero, check low byte
	return					; bypass and run feedback
	movf	SPEED_LO,w
	btfss	STATUS,Z
	return
RUN_UV
; check the undervoltage
; read battery voltage at AN10. This is divided by 6 for a 0-5V reading for a 0-30V supply 
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00101000'	; channel 10
	movwf	ADCON0
	movlw	B'11110000'	; right justified
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	movlb	D'0'		; bank 0

	call	ACQUIRE_AD	; ms result A_D_HI, ls byte in A_D_LOW	
	movf	A_D_HI,w
	movwf	BATT_HI
	movf	A_D_LOW,w
	movwf	BATT_LO

; read undervoltage setting at AN7

	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00011100'	; channel 7
	movwf	ADCON0
	movlw	B'11110000'	; right justified
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	movlb	D'0'		; bank 0

	call	ACQUIRE_AD	; ms result A_D_HI, ls byte in A_D_LOW	
	movf	A_D_LOW,w
	movwf	UV_SET_LO	; undervoltage setting low byte
	movf	A_D_HI,w
	movwf	UV_SET_HI	; undervoltage setting high byte	

; convert under voltage setting reading at AN7 where 1V=100mV (ie /10) so can compare against battery voltage reading
; which is /6
; so multiply under voltage setting by 1.66666. That's 100/60 or 165/99
	movf	UV_SET_LO,w		; undervoltage ls byte
	movwf	AARGB2
	movf	UV_SET_HI,w		; undervoltage ms byte
	movwf	AARGB1
	clrf	AARGB0		; ms byte

; Multiply by decimal 165
	movlw	D'165'
	movwf	BARGB2
	clrf	BARGB1
	clrf	BARGB0
	call	FXM2424U		; multiply
; shift result for division	
	movf	AARGB2,w		; ms of multiplication
	movwf	AARGB0
	movf	AARGB3,w		; ls byte
	movwf	AARGB1
	movf	AARGB4,w		; ms of multiplication
	movwf	AARGB2
	movf	AARGB5,w		; ls byte
	movwf	AARGB3
; Divide by D99
	clrf	BARGB0
	clrf	BARGB1
	clrf  	BARGB2
	movlw	D'99'
	movwf	BARGB3	
	call	FXD3232U		; divide

; result in AARGB2,	AARGB3,w
	movf	AARGB3,w
	movwf	UV_SET_LO	; revised undervoltage setting low byte
	movf	AARGB2,w
	movwf	UV_SET_HI	; revised undervoltage setting high byte

; is undervoltage already detected. If not check for under voltage 
	btfsc	UNDER_V,0	; undervoltage flag	if set check for return voltage (UV setting plus hysteresis)
	goto	UPPER_V		; Under Voltage plus hysteresis

; comparison. BATT_HI, BATT_LO > revised UV. If it is greater then not under voltage.
	movf	BATT_HI,w		; high byte of battery voltage
	subwf	UV_SET_HI,w		; take from setting
	movwf	TEMPX			; store
	movf	BATT_LO,w		; low byte
	subwf	UV_SET_LO,w		; setting
	btfss	STATUS,C
	decf	TEMPX,f			; decrease if required
	btfss	TEMPX,7			; if set then BATT > setting
	goto	CK_UV
	movlw	D'242'			; reset counter if battery over
	movwf	UV_COUNTER		; undervoltage counter. Must be under-voltage for 242 comparisons at 41.25ms rate (10s total)
	return

; under voltage
CK_UV

; wait 41.25ms
; preload with FAFF
	movlw	H'FA'
	call	DELAY
	movf	UV_COUNTER,w
	btfsc	STATUS,Z
	goto	UNDER_NOW
	decfsz	UV_COUNTER,f
	return
UNDER_NOW
	bsf		UNDER_V,0		; undervoltage flag set
; clear PWM
	movlb	D'12'			; bank12  PWM	
	clrf	PWM1DCH			; PWM outputs low
	clrf	PWM2DCH

; Stop PWM, PWM clear
	movlw	B'00000000'	; clear PWM mode for PWM2
	movwf	PWM2CON		; disable PWM1 operation
	clrf	PWM2DCL
	clrf	PWM2DCH		; 0 duty cycle  
	movlb	D'0'		; bank 0'
UPPER_V

; flash LED to indicate Under Voltage
FL	btfss	PORTC,6
	goto	FLASH_ON
	bcf		PORTC,6		; off

	movlw	H'7F'		; about 1s (about 8.258ms per count from FF)
	call	DELAY

FLASH_ON
	bsf		PORTC,6		; on
	movlw	H'F7'		; 65ms flash (about 8.258ms per count from FF)
	call	DELAY

; wait for voltage to go above threshold plus hysteresis
; read hysteresis setting at AN3
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00001100'	; channel 3 hysteresis
	movwf	ADCON0
	movlw	B'11110000'	; right justified
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	movlb	D'0'		; bank 0
	call	ACQUIRE_AD	; ms result A_D_HI, ls byte in A_D_LOW

; divide hysteresis by 6 as the voltage is an actual reading (ie 1V=1V) and add to undervoltage setting
	clrf	AARGB0
	clrf	AARGB1
	movf	A_D_LOW,w		; low byte
	movwf	AARGB3
	movf	A_D_HI,w		; hi byte
	movwf	AARGB2
; Divide by D6
	clrf	BARGB0
	clrf	BARGB1
	clrf  	BARGB2
	movlw	D'6'
	movwf	BARGB3	
	call	FXD3232U		; divide

; result in AARGB2,	AARGB3,w
; add to undervoltage (revised by multiplying by 1.6666)
	movf	UV_SET_LO,w
	addwf	AARGB3,f
	btfsc	STATUS,C		; if carry then increase ms byte
	incf	AARGB2,f
	movf	UV_SET_HI,w
	addwf	AARGB2,f

; compare with battery voltage at AN10
; comparison. BATT_HI, BATT_LO > revised UV. If it is greater then not under voltage.
	movf	BATT_HI,w		; high byte of battery voltage
	subwf	AARGB2,w		; take from setting
	movwf	TEMPX			; store
	movf	BATT_LO,w		; low byte
	subwf	AARGB3,w		; setting
	btfss	STATUS,C
	decf	TEMPX,f			; decrease if required
	btfss	TEMPX,7			; if set then BATT > UV setting plus hysteresis
	goto	RUN_UV	

; if over, clear soft start flag & undervoltage flag 

	clrf	SOFT_FLG		; soft start flag
	clrf	SPEED_S_HI		; speed during soft start high byte
	clrf	SPEED_S_LO		; low byte
	clrf	UNDER_V			; undervoltage flag

; allow PWM
	movlb	D'12'
	clrf	PWM2DCL
	clrf	PWM1DCL
	clrf	PWM1DCH
	clrf	PWM2DCH			; 0 duty cycle  
	movlw	B'11100000'		; set PWM mode for PWM2
	movwf	PWM2CON			; enable PWM2 operation
	movlb	D'0'			; bank 0'
	return
;.................................................................................

BCD_FREQUENCY; sets PWM frequency

; Stop PWM, PWM clear
	movlb	D'12'		; bank12  PWM	
	movlw	B'00000000'	; stop PWM mode for PWM1
	movwf	PWM1CON		; disable PWM1 operation
	clrf	PWM1DCL
	clrf	PWM1DCH		; 0 duty cycle 

	movlw	B'00000000'	; stop PWM mode for PWM2
	movwf	PWM2CON		; disable PWM1 operation
	clrf	PWM2DCL
	clrf	PWM2DCH		; 0 duty cycle  
	movlb	D'0'		; bank 0'

; read BCD switch
; 16 position BCD switch
; RA1,RB6,RB7,RB5 are the ports RB5 is lsb
	movlw	B'00001111'	; set at F (15)
	movwf	BCD			; BCD switch setting
	btfsc	PORTA,1		; if set clear bit 3
	bcf		BCD,3		; ms bit of 4-bit BCD
	btfsc	PORTB,6		; if set clear bit 2
	bcf		BCD,2		; ms bit of 4-bit BCD
	btfsc	PORTB,7		; if set clear bit 1
	bcf		BCD,1		; ms bit of 4-bit BCD
	btfsc	PORTB,5		; if set clear bit 0
	bcf		BCD,0		; ms bit of 4-bit BCD

	movf	BCD,w
	movwf	TEMPX
	btfss	STATUS,Z	; if zero
	goto	BY0
; 30.6Hz
	movlw	B'00000111'
	movwf	T2CON		; prescaler /64
	movlw	B'01110000'	; OSCCON (bits 5-2) for 2MHz
	goto	SET_OSCCON 	
BY0
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BY1
; 61.3Hz
	movlw	B'00000111'
	movwf	T2CON		; prescaler /64
	movlw	B'01110100'	; OSCCON (bits 5-2) for 4MHz
	goto	SET_OSCCON 		
BY1
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BY2
; 122.5Hz
	movlw	B'00000111'
	movwf	T2CON		; prescaler /64
	movlw	B'01111000'	; OSCCON (bits 5-2) for 8MHz
	goto	SET_OSCCON
BY2
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BY3
; 245Hz
	movlw	B'00000111'
	movwf	T2CON		; prescaler /64
	movlw	B'01111100'	; OSCCON (bits 5-2) for 16MHz
	goto	SET_OSCCON
BY3
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BY4
; 367.6Hz
	movlw	B'00000111'
	movwf	T2CON		; prescaler /64
	movlw	B'11111000'	; OSCCON (bits 5-2) for 8MHz x 3 for 24MHz
	goto	SET_OSCCON
BY4
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BY5
; 490Hz
	movlw	B'00000111'
	movwf	T2CON		; prescaler /64
	movlw	B'10111000'	; OSCCON (bits 5-2) for 8MHz x 4 for 32MHz
	goto	SET_OSCCON
BY5
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BY6
; 980Hz
	movlw	B'00000110'
	movwf	T2CON		; prescaler /16
	movlw	B'01111100'	; OSCCON (bits 5-2) for 16MHz
	goto	SET_OSCCON
BY6
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BY7
; 1.96kHz
	movlw	B'00000101'
	movwf	T2CON		; prescaler /4
	movlw	B'01111000'	; OSCCON (bits 5-2) for 8MHz
	goto	SET_OSCCON
BY7
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BY8
; 2.97kHz
	movlw	B'00000110'
	movwf	T2CON		; prescaler /16
	movlw	B'11111100'	; OSCCON (bits 5-2) for 48MHz
	goto	SET_OSCCON	
BY8
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BY9
; 3.92kHz
	movlw	B'00000101'
	movwf	T2CON		; prescaler /4
	movlw	B'01111100'	; OSCCON (bits 5-2) for 16MHz
	goto	SET_OSCCON
BY9
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BYA
; 5.88kHz
	movlw	B'00000101'
	movwf	T2CON		; prescaler /4
	movlw	B'11111000'	; OSCCON (bits 5-2) for 24MHz
	goto	SET_OSCCON	
BYA	
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BYB
; 7.84kHz
	movlw	B'00000100'
	movwf	T2CON		; prescaler /1
	movlw	B'01111000'	; OSCCON (bits 5-2) for 8MHz
	goto	SET_OSCCON	
BYB
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BYC
; 11.84kHz
	movlw	B'00000101'
	movwf	T2CON		; prescaler /4
	movlw	B'11111100'	; OSCCON (bits 5-2) for 48MHz
	goto	SET_OSCCON	
BYC
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BYD
; 15.68kHz
	movlw	B'00000100'
	movwf	T2CON		; prescaler /1
	movlw	B'01111100'	; OSCCON (bits 5-2) for 16MHz
	goto	SET_OSCCON
BYD
	decfsz	TEMPX,f		; reduce by 1, if zero then value found
	goto    BYE
; 23.5kHz
	movlw	B'00000100'
	movwf	T2CON		; prescaler /1
	movlw	B'11111000'	; OSCCON (bits 5-2) for 24MHz
	goto	SET_OSCCON
BYE
; 32.4kHz
	movlw	B'00000100'
	movwf	T2CON		; prescaler /1
	movlw	B'10111000'	; OSCCON (bits 5-2) for 8MHz x 4 for 32MHz
SET_OSCCON
	movwf	TEMP
	btfss	TEMP,7		; if bit 7 is set (PLL on), then stop and restart
	goto	NO_STOP
	bcf		TEMP,7
	movf	TEMP,w
	movlb	D'1'		; bank 1
	movwf	OSCCON
	nop
	nop
	bsf		OSCCON,7	; start PLL
	goto	ALLOW_PWM

NO_STOP 
	movlb	D'1'
	movwf	OSCCON

ALLOW_PWM
; Allow PWM, PWM set
	movlb	D'12'		; bank12  PWM	
	clrf	PWM1DCL
	clrf	PWM1DCH		; 0 duty cycle 
	movlw	B'11100000'	; set PWM mode for PWM1
	movwf	PWM1CON		; enable PWM1 operation
	clrf	PWM2DCL
	clrf	PWM2DCH		; 0 duty cycle  
	movlw	B'11100000'	; set PWM mode for PWM2
	movwf	PWM2CON		; enable PWM2 operation
	movlb	D'0'		; bank 0'

	clrf	SOFT_FLG
	return

;........................................................................................................

DELAY; uses timer1 running at 31kHz no prescaler and preloading for delay FFFF-xxFF. xx=8.25ms per count (2s max)		
; stop timer
	bcf		T1CON,0
; preload timer 1
	movwf	TMR1H			; value loaded in w before call (ms byte)
	movlw	H'FF'
	movwf	TMR1L
DELAY1
	bsf		T1CON,0			; start timer1
	bcf		PIR1,TMR1IF
TMR_LOOP1
	btfss	PIR1,TMR1IF
	goto	TMR_LOOP1
	return

DELAY2; uses timer1 running at 31kHz no prescaler and preloading for delay FFFF-FFxx. xx=32.25us per count (8.25ms max)		
; stop timer

	bcf		T1CON,0
; preload timer 1
	movwf	TMR1L	; value loaded in w before call (ls byte)
	movlw	H'FF'
	movwf	TMR1H
	goto	DELAY1			


; subroutine to wait for A/D conversion 
ACQUIRE_AD

; wait >8us to charge input capacitance 
	movlw	H'FE'
	call	DELAY2		; 32.5us
AD_1
	movlb	D'1'		; bank 1
	bsf		ADCON0,1	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,1	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	movf	ADRESL,w
	movwf	A_D_LOW		; least significant bits
	movf	ADRESH,w
	movlb	D'0'		; bank0
	movwf	A_D_HI		; A/D conversion high byte	
	return


; *********************************
; 24x24 Bit Unsigned Fixed Point Multiply 24x24 -> 48
; Input: 24 bit unsigned fixed point multiplicand in AARGB0,1,2
; 24 bit unsigned fixed point multiplier in BARGB0,1,2
; Use: CALL FXM2424U
; Output: 48 bit unsigned fixed point product in AARGB0
; Result: AARG <-- AARG x BARG
; Max Timing: 9+501+2 = 512 clks
; Min Timing: 9+150 = 159 clks

FXM2424U
	CLRF 	AARGB3 ; clear partial product
	CLRF 	AARGB4
	CLRF 	AARGB5
	MOVF 	AARGB0,W
	MOVWF 	TEMPB0
	MOVF 	AARGB1,W
	MOVWF 	TEMPB1
	MOVF 	AARGB2,W
	MOVWF 	TEMPB2

	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
LOOPUM2424A
	RRF 	BARGB2,F
	BTFSC 	STATUS,C
	GOTO 	ALUM2424NAP
	DECFSZ 	LOOPCOUNT,F
	GOTO	LOOPUM2424A
	MOVWF 	LOOPCOUNT
LOOPUM2424B
	RRF 	BARGB1,F
	BTFSC 	STATUS,C
	GOTO	BLUM2424NAP
	DECFSZ	LOOPCOUNT,F
	GOTO	LOOPUM2424B
	MOVWF	LOOPCOUNT
LOOPUM2424C
	RRF		BARGB0,F
	BTFSC 	STATUS,C
	GOTO 	CLUM2424NAP
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPUM2424C
	CLRF 	AARGB0
	CLRF 	AARGB1
	CLRF 	AARGB2
	RETLW 	0x00
CLUM2424NAP
	BCF 	STATUS,C
	GOTO 	CLUM2424NA
BLUM2424NAP
	BCF 	STATUS,C
	GOTO 	BLUM2424NA
ALUM2424NAP
	BCF 	STATUS,C
	GOTO 	ALUM2424NA
ALOOPUM2424
	RRF 	BARGB2,F
	BTFSS 	STATUS,C
	GOTO 	ALUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF	AARGB0,F
ALUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	ALOOPUM2424
	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
BLOOPUM2424
	RRF 	BARGB1,F
	BTFSS 	STATUS,C
	GOTO 	BLUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF 	AARGB0,F
BLUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	RRF 	AARGB4,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	BLOOPUM2424
	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
CLOOPUM2424
	RRF 	BARGB0,F
	BTFSS 	STATUS,C
	GOTO 	CLUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF 	AARGB0,F
CLUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	RRF 	AARGB4,F
	RRF 	AARGB5,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	CLOOPUM2424
	return

; ********************************
; 32/32 Bit Unsigned Fixed Point Divide 32/32 -> 32.32
; Input: 32 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2,AARGB3
; 32 bit unsigned fixed point divisor in BARGB0, BARGB1, BARGB2, BARGB3
; Use: CALL FXD3232U
; Output: 32 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2,AARGB3
; 32 bit unsigned fixed point remainder in REMB0, REMB1, REMB2, REMB3
; Result: AARG, REM <-- AARG / BARG
; Max Timing: 4+1025+2 = 1031 clks
; Max Timing: 4+981+2 = 987 clks
; PM: 4+359+1 = 364 DM: 13
FXD3232U
	CLRF 	REMB0
	CLRF	REMB1
	CLRF 	REMB2
	CLRF 	REMB3
	call	UDIV3232L
	return

UDIV3232L 
; Max Timing: 24+6*32+31+31+6*32+31+31+6*32+31+31+6*32+31+16 = 1025 clks
; Min Timing: 24+6*31+30+30+6*31+30+30+6*31+30+30+6*31+30+3 = 981 clks
; PM: 359 DM: 13
	CLRF 	TEMP
	RLF 	AARGB0,W
	RLF 	REMB3,F
	MOVF 	BARGB3,W
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	RLF 	AARGB0,F
	MOVLW 	H'7'
	MOVWF 	LOOPCOUNT

LOOPU3232A 
	RLF 	AARGB0,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB0,0
	GOTO 	UADD22LA
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS	STATUS,C
	INCFSZ	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22LA

UADD22LA 
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22LA 
	RLF		AARGB0,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPU3232A
	RLF 	AARGB1,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB0,0
	GOTO 	UADD22L8
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22L8

UADD22L8 
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22L8 
	RLF 	AARGB1,F
	MOVLW 	H'7'
	MOVWF 	LOOPCOUNT

LOOPU3232B 
	RLF 	AARGB1,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB1,0
	GOTO 	UADD22LB
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22LB

UADD22LB 
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22LB 
	RLF 	AARGB1,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPU3232B
	RLF 	AARGB2,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS	AARGB1,0
	GOTO 	UADD22L16
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22L16

UADD22L16 	
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF	TEMP,F

UOK22L16
	RLF		AARGB2,F
	MOVLW 	H'7'
	MOVWF 	LOOPCOUNT

LOOPU3232C 
	RLF 	AARGB2,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB2,0
	GOTO 	UADD22LC
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22LC

UADD22LC
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22LC 
	RLF 	AARGB2,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPU3232C
	RLF 	AARGB3,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB2,0
	GOTO 	UADD22L24
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22L24

UADD22L24 
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22L24 
	RLF 	AARGB3,F
	MOVLW 	H'7'
	MOVWF 	LOOPCOUNT

LOOPU3232D 
    RLF  	AARGB3,W
    RLF    	REMB3,F
    RLF    	REMB2,F
    RLF    	REMB1,F
    RLF    	REMB0,F
    RLF    	TEMP,F
    MOVF   	BARGB3,W
 	BTFSS  	AARGB3,0
   	GOTO   	UADD22LD

    SUBWF  	REMB3,F
  	MOVF   	BARGB2,W
    BTFSS   STATUS,C
    INCFSZ  BARGB2,W
    SUBWF   REMB2,F
    MOVF    BARGB1,W
    BTFSS   STATUS,C
    INCFSZ  BARGB1,W
    SUBWF   REMB1,F
    MOVF    BARGB0,W
    BTFSS   STATUS,C
    INCFSZ  BARGB0,W
    SUBWF   REMB0,F
    CLRW
    BTFSS   STATUS,C
    MOVLW   H'1'
    SUBWF   TEMP,F
    GOTO    UOK22LD

UADD22LD      
	ADDWF   REMB3,F
    MOVF    BARGB2,W
    BTFSC   STATUS,C
    INCFSZ  BARGB2,W
    ADDWF   REMB2,F
    MOVF    BARGB1,W
    BTFSC   STATUS,C
    INCFSZ  BARGB1,W
    ADDWF   REMB1,F
    MOVF    BARGB0,W
    BTFSC   STATUS,C
    INCFSZ  BARGB0,W
    ADDWF   REMB0,F
    CLRW
    BTFSC   STATUS,C
    MOVLW   H'1'
    ADDWF   TEMP,F
        
UOK22LD
	RLF     AARGB3,F

   	DECFSZ  LOOPCOUNT, F
    GOTO    LOOPU3232D

    BTFSC   AARGB3,0
    GOTO    UOK22L
    MOVF    BARGB3,W
	ADDWF   REMB3,F
    MOVF    BARGB2,W
    BTFSC   STATUS,C
    INCFSZ  BARGB2,W
    ADDWF   REMB2,F
    MOVF    BARGB1,W
    BTFSC   STATUS,C
    INCFSZ  BARGB1,W
    ADDWF   REMB1,F
    MOVF    BARGB0,W
    BTFSC   STATUS,C
    INCFSZ  BARGB0,W
    ADDWF   REMB0,F

UOK22L

	RETURN


	end

